VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "DPC_SubSys"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const SEP = ""
Private Const C_SEP As String = "@@"
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""

Private mo_Db As ARMSYSCOMLib.ArmDb
Private ml_U_Code As Long
Private ml_iConcurrency As Long
Private ms_Language_Code As String

Public CURR_Code As String
Public CT_Code As String
Public COF_Id As String
Public ValidityDate As Date

Public PUS_Id As String
Public CAT_Id As Long
Public PRD_IdPar As String
Public PRD_Child As Long
Public PRD_Code As String
Public PRD_CodeC As String
Public Vendor_Id As String
Public LEV_Id As Long
Public IMG_Id As Long
Public IMG_IdSHT As Long
Public STA_Id As Long

Public OFD_Pos As Long
Public OFD_WshDat As Date
Public OFD_ShpDat As Date
Public OFD_DelDat As Date

Public OFD_IsFree As Boolean
Public OFD_PosCus As String
Public OFD_IsAsItem As Boolean

Public LEN_Id As Long
Public SAE_Id As Long
Public SHP_Id As Long
Public VEN_Id As String
Public SAE_Name As String
Public SHP_Name As String
Public VEN_Name As String

Public SYS_Id As Long
Public SYS_Name As String
Public SYS_Desc As String
Public RF_DescA0 As String
Public RF_DescA1 As String
Public RF_DescA2 As String
Public SYS_PaSec As Boolean ' if suspension/panel security  is available this contain true
Public SYS_UseCPro As Boolean ' if suspension system containt C/D profiles logic

Public SUS_Weight As Double

Public PUS_Height As Double
Public PUS_A0 As Double
Public PUS_A1 As Double
Public PUS_A2 As Double
Public PUS_P As Double
Public PUS_Load As Long
Public PUS_LoadDesc As String
Public SHT_Id As Long
Public SHT_Name As String
Public PUS_HaAlg As Long
Public PUS_HaAlgDesc As String
Public PUS_PaSec As Boolean
Private md_PUS_PanA As Double
Private md_PUS_PanB As Double

Public SHT_Group As Long
Public SHT_MinA2 As Double
Public SHT_MaxA2 As Double
Public SHT_MinA1 As Double
Public SHT_MaxA1 As Double
Public SHT_MinA0 As Double
Public SHT_MaxA0 As Double
Public SHT_MinH  As Double
Public SHT_MaxH  As Double
Public SHT_MinPA As Double
Public SHT_MaxPA As Double
Public SHT_MinPB As Double
Public SHT_MaxPB As Double
Public SHT_Cover As Long

Public LoadKNm2 As Double

Public SLC_Idx As Long
Public MaxA0Value As Double
Public MaxA1Value As Double
Public FallAPossible As Boolean
Public FallBPossible As Boolean
Public OFD_MarginS As Double
Public OFD_GTN As Double
Public OFD_MarginMin As Double

Public lbl_PlantVendor As String
Public lbl_ShipPoint As String

Private mb_IsArticleSync As Boolean

Private ml_SubconstIdx As Long
Private mc_OfferTemplate As Long
Private mc_Error As Long

Public Subconst As New Collection
Public Errors As New Collection
Public OfferPos As DPC_OfferPos

Private mo_Tools As DPC_Tools

Private Const C_ERRORRAISE As Long = 2500

Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    SQLFailure = vbObjectError + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = vbObjectError + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = vbObjectError + 9
    CompFncFailed = vbObjectError + 10           ' when component function fail
    GridLoadFailed = vbObjectError + 11          ' load function failed ... bad sql
    QuietException = vbObjectError + 12          ' do not display error message
    SQLTableReferenceConstraint = vbObjectError + 13 ' A SQL request cannot be executed : Table reference constraint
    DuplicityDetected = vbObjectError + 2301     ' detected row with same unique id
End Enum

Property Let U_Code(al_Code As Long)
  ml_U_Code = al_Code
End Property

Property Let Language_Code(AString As String)
  ms_Language_Code = AString
End Property

Property Get Language_Code() As String
  Language_Code = ms_Language_Code
End Property

Public Property Set Tools(ByRef ao_Tools As Object)
On Error GoTo ErrorHandler

  Set mo_Tools = ao_Tools
  Exit Property
ErrorHandler:
  Call ErrorHandler("Tools.Set")
End Property

Public Property Set ArmDb(ByRef lo_Db As Object)
    If Not (lo_Db Is Nothing) Then
        Set mo_Db = lo_Db
    End If
  Exit Property
ErrHandler:
  Call ErrorHandler("ArmDb.Set")
End Property

Public Property Get ModuleSurface() As Double
On Error GoTo ErrHandler

  ModuleSurface = PUS_PanA * PUS_PanB
  Exit Property
ErrHandler:
  Call ErrorHandler("ModuleSurface.Get")
End Property

Public Property Get PanelSurface() As Double
On Error GoTo ErrHandler

  PanelSurface = PUS_PanA * PUS_PanB
  Exit Property
ErrHandler:
  Call ErrorHandler("PanelSurface.Get")
End Property

Public Property Let IsArticleSync(ByVal ab_Value As Boolean)
On Error GoTo ErrHandler

  mb_IsArticleSync = ab_Value
  If Not ab_Value Then
    Call mo_Tools.ClearCollection(Subconst)
  End If
  Exit Property
ErrHandler:
  Call ErrorHandler("IsArticleSync.Let")
End Property

Public Property Get IsArticleSync() As Boolean
On Error GoTo ErrHandler

  IsArticleSync = mb_IsArticleSync
  Exit Property
ErrHandler:
  Call ErrorHandler("IsArticleSync.Get")
End Property

Public Property Let PUS_PanA(ByVal ad_Value As Double)
On Error GoTo ErrHandler

Dim lo_Offer As DPC_OfferPos

  Set lo_Offer = GetOfferPos(eDPCOfferDetail.odSubconstPosition)
  md_PUS_PanA = ad_Value
  Call OfferPos.Init(lo_Offer.OFD_QtyM2, lo_Offer.OFD_QtyAM2, eDPCQtyType.qtM2, 0, ModuleSurface, PanelSurface)
  Exit Property
ErrHandler:
  Call ErrorHandler("PUS_PanA.Let")
End Property

Public Property Get PUS_PanA() As Double
On Error GoTo ErrHandler
  
  PUS_PanA = md_PUS_PanA
  Exit Property
ErrHandler:
  Call ErrorHandler("PUS_PanA.Get")
End Property

Public Property Let PUS_PanB(ByVal ad_Value As Double)
On Error GoTo ErrHandler

Dim lo_Offer As DPC_OfferPos

  Set lo_Offer = GetOfferPos(eDPCOfferDetail.odSubconstPosition)
  md_PUS_PanB = ad_Value
  Call OfferPos.Init(lo_Offer.OFD_QtyM2, lo_Offer.OFD_QtyAM2, eDPCQtyType.qtM2, 0, ModuleSurface, PanelSurface)
  Exit Property
ErrHandler:
  Call ErrorHandler("PUS_PanB.Let")
End Property

Public Property Get PUS_PanB() As Double
On Error GoTo ErrHandler
  
  PUS_PanB = md_PUS_PanB
  Exit Property
ErrHandler:
  Call ErrorHandler("PUS_PanB.Get")
End Property

Public Property Get PUS_QtyPCS() As Long
On Error GoTo ErrHandler
  
Dim lo_Offer As DPC_OfferPos
  
  Set lo_Offer = GetOfferPos(eDPCOfferDetail.odSubconstPosition)
  PUS_QtyPCS = lo_Offer.OFD_QtyPCS
  Exit Property
ErrHandler:
  Call ErrorHandler("PUS_QtyPCS.Get")
End Property

Public Property Get PUS_QtyM2() As Double
On Error GoTo ErrHandler
  
Dim lo_Offer As DPC_OfferPos

  Set lo_Offer = GetOfferPos(eDPCOfferDetail.odSubconstPosition)
  PUS_QtyM2 = lo_Offer.OFD_QtyM2
  Exit Property
ErrHandler:
  Call ErrorHandler("PUS_QtyM2.Get")
End Property

Public Property Let PUS_QtyM2(ByVal ad_Value As Double)
On Error GoTo ErrHandler
  
Dim lo_Offer As DPC_OfferPos

  Set lo_Offer = GetOfferPos(eDPCOfferDetail.odSubconstPosition)
  Call lo_Offer.SetQty(DPC_UOM_M2, ad_Value)
  Call lo_Offer.SetQtyA(DPC_UOM_M2, ad_Value)
  Exit Property
ErrHandler:
  Call ErrorHandler("PUS_QtyM2.Let")
End Property

Public Property Get PUS_Wght() As Double
On Error GoTo ErrHandler
  
Dim lo_Subart As DPC_SubArt
Dim ld_Weight As Double

  ld_Weight = 0
  For Each lo_Subart In Subconst
    ld_Weight = ld_Weight + lo_Subart.SUA_TWght
  Next
  PUS_Wght = ld_Weight
  Exit Property
ErrHandler:
  Call ErrorHandler("PUS_Wght.Get")
End Property

Public Sub Load_A_COM()
On Error GoTo ErrHandler

  If mo_Db Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  If mo_Tools Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  
  OFD_MarginS = 0
  OFD_GTN = 0
  OFD_MarginMin = 0
  
  Call LoadOfferTemplate
  Call LoadError
  If mo_Db.Find(mc_OfferTemplate, "DOF_Id", eDPCOfferDetail.odSubconstPosition) Then
    Set OfferPos = CreateOfferPos(mc_OfferTemplate)
    Call OfferPos.Init(0, 0, eDPCQtyType.qtM2, 0, ModuleSurface, PanelSurface)
  Else
    Err.Raise ArmErr.CompFncFailed, "mo_Db.Find", "Subconstruction position template not found"
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("Load_A_COM")
End Sub

Public Sub Unload_A_COM()
On Error GoTo ErrHandler

  Call mo_Db.Close(mc_OfferTemplate)
  Call mo_Db.Close(mc_Error)
  Exit Sub
ErrHandler:
  Call ErrorHandler("Unload_A_Com")
End Sub

Public Function CreateOfferPos(ByVal ac_OfferTemplate As Long) As DPC_OfferPos
On Error GoTo ErrHandler

Dim lo_Offer As DPC_OfferPos

  Set lo_Offer = New DPC_OfferPos
  Set lo_Offer.Tools = mo_Tools
  Call lo_Offer.ReadOfferPosTemp(mo_Db, ac_OfferTemplate)
  Set CreateOfferPos = lo_Offer
  Exit Function
ErrHandler:
  Call ErrorHandler("CreateOfferPos")
End Function

Public Sub CreateCode()
On Error GoTo ErrHandler

Dim lc_Cursor As Long
Dim ls_SYS_Code As String

  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, "exec DPC_SYS_SubChild_Next " & mo_Tools.SqlInt(SYS_Id))
  PRD_Child = mo_Db.GetFields(lc_Cursor, "SYS_SubChild")
  ls_SYS_Code = mo_Db.GetFields(lc_Cursor, "SYS_Code")
  Call mo_Db.Close(lc_Cursor)
  PRD_Code = ls_SYS_Code & "\" & PRD_Child
  Exit Sub
ErrHandler:
  Call ErrorHandler("CreateCode")
End Sub

Public Sub InitSubconst(ByVal ao_SubArt As DPC_SubArt, ByVal al_DOF_Id As eDPCOfferDetail, ByVal ae_RowStatus As eDPCRowStatus)
On Error GoTo ErrHandler

  Set ao_SubArt.Tools = mo_Tools
  ml_SubconstIdx = ml_SubconstIdx + 1
  ao_SubArt.Idx = ml_SubconstIdx
  ao_SubArt.RowStatus = ae_RowStatus
  
  If mo_Db.Find(mc_OfferTemplate, "DOF_Id", al_DOF_Id) >= 0 Then
    Set ao_SubArt.OfferPos = CreateOfferPos(mc_OfferTemplate)
    Call ao_SubArt.OfferPos.Init(0, 0, eDPCQtyType.qtPU, ao_SubArt.SUA_PU, ModuleSurface, PanelSurface)
  Else
    Err.Raise ArmErr.InvalidArgument, "al_DOF_Id", "DOF_Id not found in DPC_OfferPos: " & al_DOF_Id
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("InitSubconst")
End Sub

Public Sub SetRowStatus(ByVal ae_RowStatus As eDPCRowStatus)
On Error GoTo ErrHandler

Dim lo_Subart As DPC_SubArt

  For Each lo_Subart In Subconst
    If lo_Subart.RowStatus <> eDPCRowStatus.rsDrop Then
      lo_Subart.RowStatus = ae_RowStatus
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("SetRowStatus")
End Sub

Public Function CheckScreen(ByVal ae_Screen As eDPCScreen) As Collection
On Error GoTo ErrHandler

Dim lo_ErrCol As New Collection
  
  Select Case ae_Screen
  Case eDPCScreen.psSubconstructionSummary
    Call CheckSubconstruction(lo_ErrCol)
    Call CheckSubArt(lo_ErrCol)
  Case eDPCScreen.psSubconstruction
    Call CheckSubconstruction(lo_ErrCol)
  Case eDPCScreen.psSubconstructionArticle
    Call CheckSubArt(lo_ErrCol)
  Case Else
    Err.Raise ArmErr.InvalidArgument, "ae_Screen", "Invalid screen: " & ae_Screen
  End Select
  Call CopyErrorText(lo_ErrCol)
  Set CheckScreen = ErrorOrder(lo_ErrCol)
  Exit Function
ErrHandler:
  Call ErrorHandler("CheckScreen")
End Function

Private Sub CheckSubconstruction(ByVal ao_ErrCol As Collection)
On Error GoTo ErrHandler


  If VEN_Id = "" Then
    Call AddCheckError(eDPCError.erSubconstructionVendorMandatory, ao_ErrCol, "$fieldname$", lbl_PlantVendor)
  End If
  
  If SHP_Id = 0 Then
    Call AddCheckError(eDPCError.erSubconstructionShipPointMandatory, ao_ErrCol, "$fieldname$", lbl_ShipPoint)
  End If
  
  If SYS_Id = 0 Then
    Call AddCheckError(eDPCError.erSubconstructionSystemMandatory, ao_ErrCol)
  End If

  If PUS_PanA <= 0 Then
    Call AddCheckError(eDPCError.erSubconstructionPanelAMandatory, ao_ErrCol)
  End If

  If PUS_PanB <= 0 Then
    Call AddCheckError(eDPCError.erSubconstructionPanelBMandatory, ao_ErrCol)
  End If

  If PUS_QtyM2 = 0 Then
    Call AddCheckError(eDPCError.erSubconstructionSurfaceMandatory, ao_ErrCol)
  End If

  If PUS_Height = 0 Then
    Call AddCheckError(eDPCError.erSubconstructionHeightMandatory, ao_ErrCol)
  End If
  
  If (PUS_A0 = 0) And (MaxA0Value > 0) Then
    Call AddCheckError(eDPCError.erSubconstructionA0Mandatory, ao_ErrCol, "$a0$", RF_DescA0)
  End If
  
  If (PUS_A1 = 0) And (MaxA1Value > 0) Then
    Call AddCheckError(eDPCError.erSubconstructionA1Mandatory, ao_ErrCol, "$a1$", RF_DescA1)
  End If
  
  If PUS_A2 = 0 Then
    Call AddCheckError(eDPCError.erSubconstructionA2Mandatory, ao_ErrCol, "$a2$", RF_DescA2)
  End If

  If SYS_UseCPro And (PUS_P = 0) Then
    Call AddCheckError(eDPCError.erSubconstructionPMandatory, ao_ErrCol)
  End If
  
  If PUS_HaAlg = 0 Then
    Call AddCheckError(eDPCError.erSubconstructionHangerAlignmentMandatory, ao_ErrCol)
  End If

  If SHT_Id = 0 Then
    Call AddCheckError(eDPCError.erSubconstructionHangerTypeMandatory, ao_ErrCol)
  End If

  If PUS_Load = 0 Then
    Call AddCheckError(eDPCError.erSubconstructionLoadCaseMandatory, ao_ErrCol)
  End If

  If PUS_PaSec And (Not SYS_PaSec) Then
    Call AddCheckError(eDPCError.erSubconstructionSecurityNotAvailable, ao_ErrCol)
  End If
  
  If SYS_Id <> 0 And PUS_Load <> 0 Then
    If Not LoadHangerLoad(SYS_Id, PUS_Load) Then
      Call AddCheckError(eDPCError.erSubconstructionLoadCaseNotPossible, ao_ErrCol)
    End If
  End If
  
  If SYS_Id <> 0 And SHT_Id <> 0 Then
    If Not LoadHangerType(SYS_Id, SHT_Id) Then
      Call AddCheckError(eDPCError.erSubconstructionHangerTypeNotPossible, ao_ErrCol)
    End If
  End If
  
  Call CalculateHangerLimits
  
  If (Not FallAPossible) And (PUS_HaAlg = eDPCHangerAlignment.sfFallA) Then
    Call AddCheckError(eDPCError.erSubconstructionHangerAlignNotPossible, ao_ErrCol, "$HaAlgDesc$", PUS_HaAlgDesc)
  End If
  
  If (Not FallBPossible) And (PUS_HaAlg = eDPCHangerAlignment.sfFallB) Then
    Call AddCheckError(eDPCError.erSubconstructionHangerAlignNotPossible, ao_ErrCol, "$HaAlgDesc$", PUS_HaAlgDesc)
  End If
  
  If (SHT_MinH > 0 And PUS_Height < SHT_MinH) Or (SHT_MaxH > 0 And PUS_Height > SHT_MaxH) Then
    Call AddCheckError(eDPCError.erSubconstructionHValueOutOfLimits, ao_ErrCol, Array("$Min$", "$Max$"), Array(SHT_MinH, SHT_MaxH))
  End If
  
  If (SHT_MinA0 > 0 And PUS_A0 < SHT_MinA0) Or (SHT_MaxA0 > 0 And PUS_A0 > SHT_MaxA0) Then
    Call AddCheckError(eDPCError.erSubconstructionA0ValueOutOfLimits, ao_ErrCol, Array("$Min$", "$Max$"), Array(SHT_MinA0, SHT_MaxA0))
  End If
  
  If (PUS_A0 > MaxA0Value) Then
    'turned off, because last version of excel do not have this check
    'Call AddCheckError(eDPCError.erSubconstructionA0ValueOutOfLimits, ao_ErrCol, Array("$a0$", "$Min$", "$Max$"), Array(RF_DescA0, SHT_MinA0, MaxA0Value))
  End If
  
  If (SHT_MinA1 > 0 And PUS_A1 < SHT_MinA1) Or (SHT_MaxA1 > 0 And PUS_A1 > SHT_MaxA1) Then
    Call AddCheckError(eDPCError.erSubconstructionA1ValueOutOfLimits, ao_ErrCol, Array("$a1$", "$Min$", "$Max$"), Array(RF_DescA1, SHT_MinA1, SHT_MaxA1))
  End If
  
  If (PUS_A1 > MaxA1Value) Then
    Call AddCheckError(eDPCError.erSubconstructionA1ValueOutOfLimits, ao_ErrCol, Array("$a1$", "$Min$", "$Max$"), Array(RF_DescA1, SHT_MinA1, MaxA1Value))
  End If
  
  If (SHT_MinA2 > 0 And PUS_A2 < SHT_MinA2) Or (SHT_MaxA2 > 0 And PUS_A2 > SHT_MaxA2) Then
    Call AddCheckError(eDPCError.erSubconstructionA2ValueOutOfLimits, ao_ErrCol, Array("$a2$", "$Min$", "$Max$"), Array(RF_DescA2, SHT_MinA2, SHT_MaxA2))
  End If
  
  If (SHT_MinPA > 0 And PUS_PanA < SHT_MinPA) Or (SHT_MaxPA > 0 And PUS_PanA > SHT_MaxPA) Then
    Call AddCheckError(eDPCError.erSubconstructionPAValueOutOfLimits, ao_ErrCol, Array("$Min$", "$Max$"), Array(SHT_MinPA, SHT_MaxPA))
  End If
  
  If (SHT_MinPB > 0 And PUS_PanB < SHT_MinPB) Or (SHT_MaxPB > 0 And PUS_PanB > SHT_MaxPB) Then
    Call AddCheckError(eDPCError.erSubconstructionPBValueOutOfLimits, ao_ErrCol, Array("$Min$", "$Max$"), Array(SHT_MinPB, SHT_MaxPB))
  End If
  
  If SYS_UseCPro Then
    If (PUS_PanA < PUS_A2 - PUS_P) Or (PUS_PanA > PUS_A2) Then
      Call AddCheckError(eDPCError.erSubconstructionPAValueOutOfLimitsA2, ao_ErrCol, Array("$Min$", "$Max$"), Array(PUS_A2 - PUS_P, PUS_A2))
    End If
  Else
    If (PUS_PanA < PUS_A2 - 0.1) Or (PUS_PanA > PUS_A2) Then
      Call AddCheckError(eDPCError.erSubconstructionPAValueOutOfLimitsA2, ao_ErrCol, Array("$Min$", "$Max$"), Array(PUS_A2 - 0.1, PUS_A2))
    End If
  End If

  If (FallBPossible And (PUS_HaAlg = eDPCHangerAlignment.sfFallA)) Then
    Call AddCheckError(eDPCError.erSubconstructionHangerAlignmentBPossible, ao_ErrCol)
  End If
  
  If SHT_Cover > 0 And (Not IsArticleSync) Then
    If SHT_Cover > GetCoverValue(eDPCOfferDetail.odSubconstItemSusp) Then
      Call AddCheckError(eDPCError.erSubconstructionHeightNotCovered, ao_ErrCol)
    End If
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("CheckSubconstruction")
End Sub

Private Sub CheckSubArt(ByVal ao_ErrCol As Collection)
On Error GoTo ErrHandler

Dim lo_Subart As DPC_SubArt

  If Not IsArticleSync Then
    Call AddCheckError(eDPCError.erSubconstructionNoArticlesSync, ao_ErrCol)
  End If
  
  If Subconst.Count = 0 Then
    Call AddCheckError(eDPCError.erSubconstructionNoArticles, ao_ErrCol)
  End If
  For Each lo_Subart In Subconst
    Call CheckSubArtItem(ao_ErrCol, lo_Subart)
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("CheckSubArt")
End Sub

Public Sub CheckSubArtItem(ByVal ao_ErrCol As Collection, ByVal ao_SubArt As DPC_SubArt)
On Error GoTo ErrHandler
  
  If ao_SubArt.OfferPos.OFD_Price = 0 Then
    Call AddCheckError(eDPCError.erSubconstructionItemNoPrice, ao_ErrCol, "$PRD_Name$", ao_SubArt.PRD_Name)
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("CheckSubArtItem")
End Sub

Private Sub ResetInterfaceInfo(ByVal ao_Collection As Collection)
On Error GoTo ErrHandler

Dim lo_Subart As DPC_SubArt
  
  For Each lo_Subart In ao_Collection
    Call lo_Subart.OfferPos.ResetInterfaceInfo
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("ResetInterfaceInfo")
End Sub

Public Sub Copy()
On Error GoTo ErrHandler

  Call ResetInterfaceInfo(Subconst)
  Call SetRowStatus(eDPCRowStatus.rsAdd)
  Call CreateCode
  Exit Sub
ErrHandler:
  Call ErrorHandler("Copy")
End Sub

Public Sub Insert()
On Error GoTo ErrHandler

  PUS_Id = mo_Tools.GetNextID(mo_Db, "DPC_PrdSub")
  CAT_Id = eDPCCategory.cgSubconstruction
  LEV_Id = eDPCLevel.lvStandard
  Call InsertPrdCommon
  Call InsertPrdDesc
  Call InsertPrdSubSys
  Call SaveSubArt
  Exit Sub
ErrHandler:
  Call ErrorHandler("Insert")
End Sub

Public Sub Update()
On Error GoTo ErrHandler

  Call UpdatePrdCommon
  Call UpdatePrdDesc
  Call UpdatePrdSubSys
  Call SaveSubArt
  Exit Sub
ErrHandler:
  Call ErrorHandler("Update")
End Sub

Public Sub Drop()
On Error GoTo ErrHandler

  Call DropPrdCommon
  Exit Sub
ErrHandler:
  Call ErrorHandler("Drop")
End Sub

Private Sub SaveSubArt()
On Error GoTo ErrHandler

Dim lo_Subart As DPC_SubArt

  'first delete items to avoid add the same unique key SUB_Id, PRD_Id
  Call DeletePrdSubArt
  For Each lo_Subart In Subconst
    Call InsertPrdSubArt(lo_Subart)
  Next
'  For Each lo_SubArt In Subconst
'    If StrComp(lo_SubArt.RowStatus, "D", vbTextCompare) = 0 Then
'      Call DropPrdSubArt(lo_SubArt)
'    End If
'  Next
'  For Each lo_SubArt In Subconst
'    If StrComp(lo_SubArt.RowStatus, "U", vbTextCompare) = 0 Then
'      Call UpdatePrdSubArt(lo_SubArt)
'    End If
'  Next
'  For Each lo_SubArt In Subconst
'    If StrComp(lo_SubArt.RowStatus, "A", vbTextCompare) = 0 Then
'      Call InsertPrdSubArt(lo_SubArt)
'    End If
'  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("SaveSubArt")
End Sub

Private Sub InsertPrdCommon()
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_PrdCommon_ins $PRD_Id$, $CAT_Id$, $PRD_IdPar$, $PRD_Child$, $PRD_Code$, $PRD_CodeC$,"
  ls_req = ls_req & "$Vendor_Id$, $LEV_Id$, $ERR_Type$, $IMG_Id$, $STA_Id$, $S_Code$, $Z_Creator$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(PUS_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CAT_Id$", mo_Tools.SqlInt(CAT_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_IdPar$", mo_Tools.SqlStrKey(PRD_IdPar), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Child$", mo_Tools.SqlInt(PRD_Child), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Code$", mo_Tools.SQLStr(PRD_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_CodeC$", mo_Tools.SQLStr(PRD_CodeC), , , vbTextCompare)
  ls_req = Replace(ls_req, "$Vendor_Id$", mo_Tools.SqlStrKey(Vendor_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$LEV_Id$", mo_Tools.SqlInt(LEV_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$ERR_Type$", mo_Tools.SqlInt(eDPCErrorType.etNone), , , vbTextCompare)
  ls_req = Replace(ls_req, "$IMG_Id$", mo_Tools.SqlIntKey(IMG_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$STA_Id$", mo_Tools.SqlIntKey(STA_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$S_Code$", "NULL", , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Exit Sub
ErrHandler:
  Call ErrorHandler("InsertPrdCommon")
End Sub

Private Sub UpdatePrdCommon()
On Error GoTo ErrHandler

Dim ls_req As String

  
  ls_req = "exec DPC_PrdCommon_upd $PRD_Id$, $CAT_Id$, $PRD_IdPar$, $PRD_Child$, $PRD_Code$, $PRD_CodeC$,"
  ls_req = ls_req & "$Vendor_Id$, $LEV_Id$, $ERR_Type$, $IMG_Id$, $STA_Id$, $S_Code$, $Z_Last_Upd_User$, $iConcurrency$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(PUS_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CAT_Id$", mo_Tools.SqlInt(CAT_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_IdPar$", mo_Tools.SqlStrKey(PRD_IdPar), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Child$", mo_Tools.SqlInt(PRD_Child), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Code$", mo_Tools.SQLStr(PRD_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_CodeC$", mo_Tools.SQLStr(PRD_CodeC), , , vbTextCompare)
  ls_req = Replace(ls_req, "$Vendor_Id$", mo_Tools.SqlStrKey(Vendor_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$LEV_Id$", mo_Tools.SqlInt(LEV_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$ERR_Type$", mo_Tools.SqlInt(eDPCErrorType.etNone), , , vbTextCompare)
  ls_req = Replace(ls_req, "$IMG_Id$", mo_Tools.SqlInt(IMG_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$STA_Id$", mo_Tools.SqlInt(STA_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$S_Code$", "NULL", , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Exit Sub
ErrHandler:
  Call ErrorHandler("UpdatePrdCommon")
End Sub

Private Sub DropPrdCommon()
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_PrdCommon_del $PRD_Id$,$Z_Last_Upd_User$,$iConcurrency$"
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(PUS_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Exit Sub
ErrHandler:
  Call ErrorHandler("DropPrdCommon")
End Sub

Private Sub InsertPrdDesc()
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_PrdDesc_ins $PRD_Id$, $Language_Code$, $PRD_Name$, $PRD_Desc$,$Z_Creator$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(PUS_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Name$", mo_Tools.SQLStr(SYS_Name), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Desc$", mo_Tools.SQLStr(SYS_Desc), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Exit Sub
ErrHandler:
  Call ErrorHandler("InsertPrdDesc")
End Sub

Private Sub UpdatePrdDesc()
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_PrdDesc_upd $PRD_Id$, $Language_Code$, $PRD_Name$, $PRD_Desc$,$Z_Last_Upd_User$"
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(PUS_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Name$", mo_Tools.SQLStr(SYS_Name), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Desc$", mo_Tools.SQLStr(SYS_Desc), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Exit Sub
ErrHandler:
  Call ErrorHandler("UpdatePrdDesc")
End Sub

Private Sub DropPrdDesc()
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_PrdDesc_del $PRD_Id$,$Z_Last_Upd_User$"
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(PUS_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Exit Sub
ErrHandler:
  Call ErrorHandler("DropPrdDesc")
End Sub

Private Sub InsertPrdSubSys()
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_PrdSub_ins $PUS_Id$, $SYS_Id$, $PUS_QtyM2$, $SHT_Id$, $PUS_Height$, $PUS_Load$, $PUS_HaAlg$,"
  ls_req = ls_req & "$PUS_A0$, $PUS_A1$, $PUS_A2$, $PUS_PaSec$, $PUS_PanA$, $PUS_PanB$, $PUS_P$, $PUS_Wght$, $Z_Creator$"
  
  ls_req = Replace(ls_req, "$PUS_Id$", mo_Tools.SQLStr(PUS_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$SYS_Id$", mo_Tools.SqlIntKey(SYS_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_QtyM2$", mo_Tools.SqlDbl(PUS_QtyM2), , , vbTextCompare)
  ls_req = Replace(ls_req, "$SHT_Id$", mo_Tools.SqlIntKey(SHT_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_Height$", mo_Tools.SqlDbl(PUS_Height), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_Load$", mo_Tools.SqlIntKey(PUS_Load), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_HaAlg$", mo_Tools.SqlIntKey(PUS_HaAlg), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_A0$", mo_Tools.SqlDbl(PUS_A0), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_A1$", mo_Tools.SqlDbl(PUS_A1), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_A2$", mo_Tools.SqlDbl(PUS_A2), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_PaSec$", mo_Tools.SqlBool(PUS_PaSec), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_PanA$", mo_Tools.SqlDbl(PUS_PanA), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_PanB$", mo_Tools.SqlDbl(PUS_PanB), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_P$", mo_Tools.SqlDbl(PUS_P), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_Wght$", mo_Tools.SqlDbl(PUS_Wght), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Exit Sub
ErrHandler:
  Call ErrorHandler("InsertPrdSubSys")
End Sub

Private Sub UpdatePrdSubSys()
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_PrdSub_upd $PUS_Id$, $SYS_Id$, $PUS_QtyM2$, $SHT_Id$, $PUS_Height$, $PUS_Load$, $PUS_HaAlg$,"
  ls_req = ls_req & "$PUS_A0$, $PUS_A1$, $PUS_A2$, $PUS_PaSec$, $PUS_PanA$, $PUS_PanB$, $PUS_P$, $PUS_Wght$, $Z_Last_Upd_User$"
  
  ls_req = Replace(ls_req, "$PUS_Id$", mo_Tools.SQLStr(PUS_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$SYS_Id$", mo_Tools.SqlIntKey(SYS_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_QtyM2$", mo_Tools.SqlDbl(PUS_QtyM2), , , vbTextCompare)
  ls_req = Replace(ls_req, "$SHT_Id$", mo_Tools.SqlIntKey(SHT_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_Height$", mo_Tools.SqlDbl(PUS_Height), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_Load$", mo_Tools.SqlIntKey(PUS_Load), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_HaAlg$", mo_Tools.SqlIntKey(PUS_HaAlg), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_A0$", mo_Tools.SqlDbl(PUS_A0), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_A1$", mo_Tools.SqlDbl(PUS_A1), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_A2$", mo_Tools.SqlDbl(PUS_A2), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_PaSec$", mo_Tools.SqlBool(PUS_PaSec), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_PanA$", mo_Tools.SqlDbl(PUS_PanA), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_PanB$", mo_Tools.SqlDbl(PUS_PanB), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_P$", mo_Tools.SqlDbl(PUS_P), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_Wght$", mo_Tools.SqlDbl(PUS_Wght), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Exit Sub
ErrHandler:
  Call ErrorHandler("UpdatePrdSubSys")
End Sub

Private Sub DropPrdSubSys()
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_PrdSub_del $PUS_Id$,$Z_Last_Upd_User$"
  ls_req = Replace(ls_req, "$PUS_Id$", mo_Tools.SQLStr(PUS_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Exit Sub
ErrHandler:
  Call ErrorHandler("DropPrdSubSys")
End Sub

Private Sub InsertPrdSubArt(ByVal ao_SubArt As DPC_SubArt)
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_PrdSubArt_ins $PUS_Id$, $SUA_Id$, $DOF_Id$, $PSA_Qty$, $PSA_QtyA$,"
  ls_req = ls_req & "$PSA_PU$, $PSA_Bwrt$, $PSA_NeedPCS$, $PSA_NeedM2$,$Z_Creator$"
  
  ls_req = Replace(ls_req, "$PUS_Id$", mo_Tools.SqlStrKey(PUS_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$SUA_Id$", mo_Tools.SqlStrKey(ao_SubArt.SUA_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$DOF_Id$", mo_Tools.SqlIntKey(ao_SubArt.OfferPos.DOF_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PSA_Qty$", mo_Tools.SqlDbl(ao_SubArt.OfferPos.OFD_QtyPU), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PSA_QtyA$", mo_Tools.SqlDbl(ao_SubArt.OfferPos.OFD_QtyAPU), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$PSA_PU$", mo_Tools.SqlDbl(ao_SubArt.SUA_PU), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PSA_Bwrt$", mo_Tools.SqlDbl(ao_SubArt.SUA_Bwrt), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PSA_NeedPCS$", mo_Tools.SqlDbl(ao_SubArt.PSA_NeedPCS), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PSA_NeedM2$", mo_Tools.SqlDbl(ao_SubArt.PSA_NeedM2), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Exit Sub
ErrHandler:
  Call ErrorHandler("InsertPrdSubArt")
End Sub

Private Sub UpdatePrdSubArt(ByVal ao_SubArt As DPC_SubArt)
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_PrdSubArt_upd $PUS_Id$, $SUA_Id$, $DOF_Id$, $PSA_Qty$, $PSA_QtyA$,"
  ls_req = ls_req & "$PSA_PU$, $PSA_Bwrt$, $PSA_NeedPCS$, $PSA_NeedM2$,$Z_Last_Upd_User$"
  
  ls_req = Replace(ls_req, "$PUS_Id$", mo_Tools.SqlStrKey(PUS_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$SUA_Id$", mo_Tools.SqlStrKey(ao_SubArt.SUA_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$DOF_Id$", mo_Tools.SqlIntKey(ao_SubArt.OfferPos.DOF_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PSA_Qty$", mo_Tools.SqlDbl(ao_SubArt.OfferPos.OFD_QtyPU), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PSA_QtyA$", mo_Tools.SqlDbl(ao_SubArt.OfferPos.OFD_QtyAPU), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$PSA_PU$", mo_Tools.SqlDbl(ao_SubArt.SUA_PU), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PSA_Bwrt$", mo_Tools.SqlDbl(ao_SubArt.SUA_Bwrt), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PSA_NeedPCS$", mo_Tools.SqlDbl(ao_SubArt.PSA_NeedPCS), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PSA_NeedM2$", mo_Tools.SqlDbl(ao_SubArt.PSA_NeedM2), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Exit Sub
ErrHandler:
  Call ErrorHandler("UpdatePrdSubArt")
End Sub

Private Sub DropPrdSubArt(ByVal ao_SubArt As DPC_SubArt)
On Error GoTo ErrHandler

Dim ls_req As String

  If ao_SubArt.RowStatus <> eDPCRowStatus.rsDrop Then
    Err.Raise 0, "DropPrdSubconst", "DropPrdSubconst"
  End If
  
  ls_req = "exec DPC_PrdSubArt_del $PUS_Id$, $SUA_Id$, $DOF_Id$, $Z_Last_Upd_User$"
  
  ls_req = Replace(ls_req, "$PUS_Id$", mo_Tools.SqlStrKey(PUS_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$SUA_Id$", mo_Tools.SqlStrKey(ao_SubArt.SUA_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$DOF_Id$", mo_Tools.SqlIntKey(ao_SubArt.OfferPos.DOF_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Exit Sub
ErrHandler:
  Call ErrorHandler("DropPrdSubArt")
End Sub

Private Sub DeletePrdSubArt()
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_PrdSubArt_del2 $PUS_Id$, $Z_Last_Upd_User$"
  
  ls_req = Replace(ls_req, "$PUS_Id$", mo_Tools.SQLStr(PUS_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Exit Sub
ErrHandler:
  Call ErrorHandler("DeletePrdSubArt")
End Sub

Public Function LoadVendorShipPoint(ByVal as_CT_Code As String) As Boolean
On Error GoTo ErrHandler

Dim lo_Offer As DPC_OfferPos

  LoadVendorShipPoint = False
  Set lo_Offer = GetOfferPos(eDPCOfferDetail.odSubconstPosition)
  If Not lo_Offer Is Nothing Then
    Call lo_Offer.LoadVendor(mo_Db, as_CT_Code)
    Call lo_Offer.LoadShipPoint(mo_Db, as_CT_Code)
    VEN_Id = lo_Offer.VEN_Id
    VEN_Name = lo_Offer.VEN_Name
    SHP_Id = lo_Offer.SHP_Id
    SHP_Name = lo_Offer.SHP_Name
    LoadVendorShipPoint = True
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("LoadVendorShipPoint")
End Function

Public Sub ClearSystem()
On Error GoTo ErrHandler

  Call LoadHangerType(0, 0)
  Call ClearSuspParams
  Exit Sub
ErrHandler:
  Call ErrorHandler("ClearSystem")
End Sub

Public Sub ClearHanger()
On Error GoTo ErrHandler

  Call ClearSuspParams
  Exit Sub
ErrHandler:
  Call ErrorHandler("ClearSystem")
End Sub

Public Sub ClearSuspParams()
On Error GoTo ErrHandler

  PUS_A0 = 0
  PUS_A1 = 0
  PUS_A2 = 0
  PUS_HaAlg = eDPCHangerAlignment.sfUnknown
  PUS_HaAlgDesc = ""
  PUS_Load = 0
  PUS_LoadDesc = ""
  PUS_Height = 0
  PUS_PanA = 0
  PUS_PanB = 0
  PUS_PaSec = False
  PUS_P = 0
  Exit Sub
ErrHandler:
  Call ErrorHandler("ClearSuspParams")
End Sub

Public Sub LoadSystem(ByVal al_SYS_Id As Long)
On Error GoTo ErrHandler

Dim ls_Request As String
Dim lc_Cursor As Long

  ls_Request = "exec DPC_System_sel $SYS_Id$,$Language_Code$"
  
  ls_Request = ReplaceCommonPlaceholders(ls_Request)
  ls_Request = Replace(ls_Request, "$SYS_Id$", mo_Tools.SqlInt(al_SYS_Id), , , vbTextCompare)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  If mo_Db.RowCount(lc_Cursor) = 1 Then
    SYS_Id = mo_Db.GetFields(lc_Cursor, "SYS_Id")
    SYS_Name = mo_Db.GetFields(lc_Cursor, "SYS_Name")
    SYS_Desc = mo_Db.GetFields(lc_Cursor, "SYS_Desc")
    IMG_Id = mo_Db.GetFields(lc_Cursor, "IMG_IdSUB")
    RF_DescA0 = mo_Db.GetFields(lc_Cursor, "RF_DescA0")
    RF_DescA1 = mo_Db.GetFields(lc_Cursor, "RF_DescA1")
    RF_DescA2 = mo_Db.GetFields(lc_Cursor, "RF_DescA2")
    SYS_PaSec = (StrComp(mo_Db.GetFields(lc_Cursor, "SYS_PaSec"), "X", vbTextCompare) = 0)
    SYS_UseCPro = (StrComp(mo_Db.GetFields(lc_Cursor, "SYS_UseCPro"), "X", vbTextCompare) = 0)
  Else
    SYS_Id = 0
    SYS_Name = ""
    SYS_Desc = ""
    IMG_Id = 0
    RF_DescA0 = ""
    RF_DescA1 = ""
    RF_DescA2 = ""
    SYS_PaSec = False
    SYS_UseCPro = False
  End If
  Call mo_Db.Close(lc_Cursor)
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadSystem")
End Sub

Public Function LoadHangerType(ByVal al_SYS_Id As Long, ByVal al_HangerType As Long)
On Error GoTo ErrHandler

Dim ls_Request As String
Dim lc_Cursor As Long

  LoadHangerType = False
  If (al_SYS_Id <> 0) And (al_HangerType <> 0) Then
    ls_Request = "exec DPC_SubHangType_sel2 $SYS_Id$,$SHT_Id$,$Language_Code$ "
    
    ls_Request = Replace(ls_Request, "$SYS_Id$", mo_Tools.SqlInt(al_SYS_Id), , , vbTextCompare)
    ls_Request = Replace(ls_Request, "$SHT_Id$", mo_Tools.SqlInt(al_HangerType), , , vbTextCompare)
    ls_Request = ReplaceCommonPlaceholders(ls_Request)
    lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
    If mo_Db.RowCount(lc_Cursor) = 1 Then
      SHT_Id = mo_Db.GetFields(lc_Cursor, "SHT_Id")
      SHT_Name = mo_Db.GetFields(lc_Cursor, "SHT_Name")
  
      SHT_Group = mo_Db.GetFields(lc_Cursor, "SHT_Group")
      SHT_MinA2 = Round(mo_Db.GetFields(lc_Cursor, "SHT_MinA2"), 3)
      SHT_MaxA2 = Round(mo_Db.GetFields(lc_Cursor, "SHT_MaxA2"), 3)
      SHT_MinA1 = Round(mo_Db.GetFields(lc_Cursor, "SHT_MinA1"), 3)
      SHT_MaxA1 = Round(mo_Db.GetFields(lc_Cursor, "SHT_MaxA1"), 3)
      SHT_MinA0 = Round(mo_Db.GetFields(lc_Cursor, "SHT_MinA0"), 3)
      SHT_MaxA0 = Round(mo_Db.GetFields(lc_Cursor, "SHT_MaxA0"), 3)
      SHT_MinH = Round(mo_Db.GetFields(lc_Cursor, "SHT_MinH"), 3)
      SHT_MaxH = Round(mo_Db.GetFields(lc_Cursor, "SHT_MaxH"), 3)
      SHT_MinPA = Round(mo_Db.GetFields(lc_Cursor, "SHT_MinPA"), 3)
      SHT_MaxPA = Round(mo_Db.GetFields(lc_Cursor, "SHT_MaxPA"), 3)
      SHT_MinPB = Round(mo_Db.GetFields(lc_Cursor, "SHT_MinPB"), 3)
      SHT_MaxPB = Round(mo_Db.GetFields(lc_Cursor, "SHT_MaxPB"), 3)
      SHT_Cover = mo_Db.GetFields(lc_Cursor, "SHT_Cover")
      IMG_IdSHT = mo_Db.GetFields(lc_Cursor, "IMG_IdSHT")
      LoadHangerType = True
    End If
    Call mo_Db.Close(lc_Cursor)
  Else
    SHT_Id = 0
    SHT_Name = ""

    SHT_Group = 0
    SHT_MinA2 = 0
    SHT_MaxA2 = 0
    SHT_MinA1 = 0
    SHT_MaxA1 = 0
    SHT_MinA0 = 0
    SHT_MaxA0 = 0
    SHT_MinH = 0
    SHT_MaxH = 0
    SHT_Cover = 0
    IMG_IdSHT = 0
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("LoadHangerType")
End Function

Public Function LoadHangerLoad(ByVal al_SYS_Id As Long, ByVal al_HangerLoad As Long)
On Error GoTo ErrHandler

Dim ls_Request As String
Dim lc_Cursor As Long

  LoadHangerLoad = False
  
  If (al_SYS_Id <> 0) And (al_HangerLoad <> 0) Then
    ls_Request = "exec DPC_SysSubLoad_sel $SYS_Id$,$SSL_Load$,$Language_Code$"
    
    ls_Request = Replace(ls_Request, "$SYS_Id$", mo_Tools.SqlInt(al_SYS_Id))
    ls_Request = Replace(ls_Request, "$SSL_Load$", mo_Tools.SqlInt(al_HangerLoad))
    ls_Request = ReplaceCommonPlaceholders(ls_Request)
    
    lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
    If mo_Db.RowCount(lc_Cursor) = 1 Then
    
      PUS_Load = mo_Db.GetFields(lc_Cursor, "SSL_Load")
      PUS_LoadDesc = mo_Db.GetFields(lc_Cursor, "SSL_LoadName")
      LoadKNm2 = Round(mo_Db.GetFields(lc_Cursor, "SSL_Wght"), 3)
      SLC_Idx = mo_Db.GetFields(lc_Cursor, "SLC_Idx")
      
      LoadHangerLoad = True
    End If
    Call mo_Db.Close(lc_Cursor)
  Else
    PUS_Load = 0
    PUS_LoadDesc = ""
    LoadKNm2 = 0
    SLC_Idx = 0
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("LoadHangerLoad")
End Function

Public Function LoadHangerAlignment(ByVal al_HangerAlignment As Long)
On Error GoTo ErrHandler

Dim ls_Request As String
Dim lc_Cursor As Long

  LoadHangerAlignment = False
  
  If (al_HangerAlignment <> 0) Then
    ls_Request = "exec A_References_ML_sel $GR_Code$,$RF_CodeHA$,$Language_Code$"
    
    ls_Request = Replace(ls_Request, "$GR_Code$", mo_Tools.SqlInt(eDPCReferenceML.rfSubHangAlignment))
    ls_Request = Replace(ls_Request, "$RF_CodeHA$", mo_Tools.SqlInt(al_HangerAlignment))
    ls_Request = Replace(ls_Request, "$Language_Code$", mo_Tools.SQLStr(Language_Code))
    ls_Request = ReplaceCommonPlaceholders(ls_Request)
    lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
    If mo_Db.RowCount(lc_Cursor) = 1 Then
      PUS_HaAlg = mo_Db.GetFields(mo_Db, "RF_Code")
      PUS_HaAlgDesc = mo_Db.GetFields(mo_Db, "RF_Desc")
      LoadHangerAlignment = True
    End If
    Call mo_Db.Close(lc_Cursor)
  Else
    PUS_HaAlg = 0
    PUS_HaAlgDesc = ""
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("LoadHangerAlignment")
End Function

Private Function LoadA0A1MaxValues(ByVal al_SLC_Idx As Long, ByVal ad_PUS_A2 As Double, ByVal al_LoadCase As Long, ByVal al_SHT_Group As Long) As Boolean
On Error GoTo ErrHandler

Dim ls_Request As String
Dim lc_Cursor As Long
Dim ls_FieldA As String
Dim ls_FieldB As String
Dim ld_A0A1TableValueFallA As Double
Dim ld_A0A1TableValueFallB As Double
Dim ld_FallAMaxA0Value As Double
Dim ld_FallAMaxA1Value As Double
Dim ld_FallBMaxA0Value As Double
Dim ld_FallBMaxA1Value As Double
Dim ld_A2 As Double

  LoadA0A1MaxValues = False
  
  MaxA0Value = 0
  MaxA1Value = 0
  FallAPossible = False
  FallBPossible = False
  
  ld_A2 = RoundUp(ad_PUS_A2 * 20) / 20
  ld_FallAMaxA0Value = 0
  ld_FallAMaxA1Value = 0
  ld_FallBMaxA0Value = 0
  ld_FallBMaxA1Value = 0
  
  ls_Request = "exec DPC_SubA0A1Data_Sel2 $SLC_Idx$,$SLC_SizeA2$,$Language_Code$"
  
  ls_Request = Replace(ls_Request, "$SLC_Idx$", mo_Tools.SqlInt(al_SLC_Idx), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$SLC_SizeA2$", mo_Tools.SqlDbl(ld_A2), , , vbTextCompare)
  ls_Request = ReplaceCommonPlaceholders(ls_Request)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  If mo_Db.RowCount(lc_Cursor) = 1 Then
    ls_FieldA = "SLC_HAA" & al_LoadCase
    ls_FieldB = "SLC_HAB" & al_LoadCase
    If (mo_Db.GetFieldIndex(lc_Cursor, ls_FieldA) >= 0) And (mo_Db.GetFieldIndex(lc_Cursor, ls_FieldB) >= 0) Then
      ld_A0A1TableValueFallA = mo_Db.GetFields(lc_Cursor, ls_FieldA)
      ld_A0A1TableValueFallB = mo_Db.GetFields(lc_Cursor, ls_FieldB)
      
      If (al_SHT_Group = eDPCSubconstHangTypeGroup.hgGemaGrid) Or _
         (al_SHT_Group = eDPCSubconstHangTypeGroup.hgDP12) Or _
         (al_SHT_Group = eDPCSubconstHangTypeGroup.hgNoGroup) Then
         ld_FallAMaxA1Value = ld_A0A1TableValueFallA
      End If
      If ld_FallAMaxA1Value = 0 Then
        ld_FallAMaxA0Value = ld_A0A1TableValueFallA
      Else
        If ld_A0A1TableValueFallA > 0 Then
          If ad_PUS_A2 > SHT_MaxA0 Then
            ld_FallAMaxA0Value = SHT_MaxA0
          Else
            ld_FallAMaxA0Value = ad_PUS_A2
          End If
        End If
      End If
      
      If (al_SHT_Group = eDPCSubconstHangTypeGroup.hgGemaGrid) Or _
         (al_SHT_Group = eDPCSubconstHangTypeGroup.hgDP12) Or _
         (al_SHT_Group = eDPCSubconstHangTypeGroup.hgNoGroup) Then
         ld_FallBMaxA1Value = ld_A0A1TableValueFallB
      End If
      
      If ld_A0A1TableValueFallB > 0 Then
         If (2 * ad_PUS_A2) > SHT_MaxA0 Then
           ld_FallBMaxA0Value = SHT_MaxA0
         Else
           ld_FallBMaxA0Value = (2 * ad_PUS_A2)
         End If
      End If
      If PUS_HaAlg = eDPCHangerAlignment.sfFallA Then
        MaxA0Value = ld_FallAMaxA0Value
        MaxA1Value = ld_FallAMaxA1Value
      ElseIf PUS_HaAlg = eDPCHangerAlignment.sfFallB Then
        MaxA0Value = ld_FallBMaxA0Value
        MaxA1Value = ld_FallBMaxA1Value
      End If
      
      If (ld_A0A1TableValueFallA <> 0 And ld_A0A1TableValueFallB = 0) Then
        FallAPossible = True
      Else
        FallAPossible = True
        FallBPossible = True
      End If
      LoadA0A1MaxValues = True
    End If
  End If
  Call mo_Db.Close(lc_Cursor)
  Exit Function
ErrHandler:
  Call ErrorHandler("LoadA0A1MaxValues")
End Function

Public Sub LoadSubArtPrice(ByVal ao_SubArt As DPC_SubArt)
On Error GoTo ErrHandler

Dim ls_req As String
Dim lc_Cursor As Long
Dim ld_Cost As Double

  ld_Cost = 0
  ls_req = "exec DPC_Cost_sel2 $PRD_Id$, $VEN_Id$, $CT_Code$,$CURR_Code$,$UM_CodeC$,$VDate$,$Qty$,$UM_CodeQ$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(ao_SubArt.SUA_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$VEN_Id$", mo_Tools.SqlStrKey(ao_SubArt.Vendor_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CT_Code$", mo_Tools.SQLStr(CT_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CURR_Code$", mo_Tools.SQLStr(CURR_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$UM_CodeC$", mo_Tools.SQLStr(DPC_UOM_PU), , , vbTextCompare)
  ls_req = Replace(ls_req, "$VDate$", mo_Tools.SqlDate(Date), , , vbTextCompare)
  ls_req = Replace(ls_req, "$Qty$", mo_Tools.SqlDbl(ao_SubArt.OfferPos.OFD_QtyPU), , , vbTextCompare)
  ls_req = Replace(ls_req, "$UM_CodeQ$", mo_Tools.SQLStr(DPC_UOM_PU), , , vbTextCompare)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  If mo_Db.RowCount(lc_Cursor) = 1 Then
    ld_Cost = mo_Db.GetFields(lc_Cursor, "PRC_Cost")
  End If
  Call ao_SubArt.OfferPos.SetCost(DPC_UOM_PU, ld_Cost)
  Call ao_SubArt.OfferPos.SetCostA(DPC_UOM_PU, ld_Cost)
  ao_SubArt.OfferPos.OFD_Disco = 0
  ao_SubArt.OfferPos.OFD_MarginS = OFD_MarginS
  ao_SubArt.OfferPos.OFD_GTN = OFD_GTN
  ao_SubArt.OfferPos.OFD_MarginMin = OFD_MarginMin
  Call ao_SubArt.OfferPos.CalculateGrossSellingPrice
  'Call ao_SubArt.OfferPos.SetPrice(DPC_UOM_PU, ld_Cost)
  'Call ao_SubArt.OfferPos.SetPriceA(DPC_UOM_PU, ld_Cost)
  ao_SubArt.OfferPos.OFD_Found = mo_Db.RowCount(lc_Cursor)
  Call mo_Db.Close(lc_Cursor)
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadSubArtPrice")
End Sub

Public Function CalculateHangerLimits() As Boolean
On Error GoTo ErrHandler

  CalculateHangerLimits = LoadA0A1MaxValues(SLC_Idx, PUS_A2, PUS_Load, SHT_Group)
  Exit Function
ErrHandler:
  Call ErrorHandler("CalculateHangerLimits")
End Function

Private Function GetCoverValue(ByVal al_DOF_Id As Long)
On Error GoTo ErrHandler

Dim lo_Subart As DPC_SubArt
Dim ll_Cover As Long

  ll_Cover = 0
  For Each lo_Subart In Subconst
    If lo_Subart.OfferPos.DOF_Id = al_DOF_Id Then
      If lo_Subart.SHL_Cover > ll_Cover Then
        ll_Cover = lo_Subart.SHL_Cover
      End If
    End If
  Next
  GetCoverValue = ll_Cover
  Exit Function
ErrHandler:
  Call ErrorHandler("GetCoverValue")
End Function

Public Function RoundUp(ByVal ad_Value As Double) As Long
On Error GoTo ErrHandler

  If Int(ad_Value) = ad_Value Then
    RoundUp = Int(ad_Value)
  Else
    RoundUp = Int(ad_Value) + 1
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("RoundUp")
End Function

Public Sub LoadOfferTemplate()
On Error GoTo ErrHandler

Dim ls_req As String

  If mc_OfferTemplate = 0 Then
    ls_req = "exec DPC_Offer_lst $DOF_Source$, $Language_Code$"
    ls_req = Replace(ls_req, "$DOF_Source$", mo_Tools.SqlInt(eDPCOffferDetailSource.dsSubconstConfigPosition), , , vbTextCompare)
    ls_req = ReplaceCommonPlaceholders(ls_req)
    mc_OfferTemplate = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadOfferTemplate")
End Sub

Public Function Calculate() As Boolean
On Error GoTo ErrHandler

Dim ls_req As String
Dim lc_Cursor As Long
Dim lo_Subart As DPC_SubArt
  
  Call mo_Tools.ClearCollection(Subconst)
  Call LoadSystemMargin
  OfferPos.OFD_Disco = 0
  OfferPos.OFD_MarginS = OFD_MarginS
  OfferPos.OFD_GTN = OFD_GTN
  OfferPos.OFD_MarginMin = OFD_MarginMin
  
  Call CalculateHangerLimits
  
  ls_req = "DPC_SubHangTypeLim_lst2 $SYS_Id$, $SHT_Id$, $DOF_Id$, $PUS_Height$, $SYS_UseCPro$, $PUS_P$, $Language_Code$"
  
  ls_req = Replace(ls_req, "$SYS_Id$", mo_Tools.SqlInt(SYS_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$SHT_Id$", mo_Tools.SqlInt(SHT_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_Height$", mo_Tools.SqlDbl(PUS_Height), , , vbTextCompare)
  ls_req = Replace(ls_req, "$DOF_Id$", mo_Tools.SqlInt(eDPCOfferDetail.odSubconstItemSusp), , , vbTextCompare)
  ls_req = Replace(ls_req, "$SYS_UseCPro$", mo_Tools.SqlBool(SYS_UseCPro), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_P$", mo_Tools.SqlDbl(PUS_P * 1000), , , vbTextCompare)
  ls_req = Replace(ls_req, "$Language_Code$", mo_Tools.SQLStr(Language_Code), , , vbTextCompare)
  
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  While Not mo_Db.EOF(lc_Cursor)
    Set lo_Subart = New DPC_SubArt
    Call InitSubconst(lo_Subart, eDPCOfferDetail.odSubconstItemSusp, eDPCRowStatus.rsAdd)
    Call ReadSubconst(lo_Subart, lc_Cursor)
    Call lo_Subart.CalculateRequiredQty(PUS_QtyM2, PUS_QtyPCS, PUS_A0, PUS_A1, PUS_A2)
    Call LoadSubArtPrice(lo_Subart)
    Call SubconstAdd(lo_Subart)
    Call mo_Db.Next(lc_Cursor)
  Wend
  Call mo_Db.Close(lc_Cursor)

  ls_req = "exec DPC_SubGrid_lst2 $SYS_Id$,$SHT_Id$,$DOF_Id$, $SYS_UseCPro$, $PUS_P$, $Language_Code$"
  
  ls_req = Replace(ls_req, "$SYS_Id$", mo_Tools.SqlInt(SYS_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$SHT_Id$", mo_Tools.SqlInt(SHT_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$DOF_Id$", mo_Tools.SqlInt(eDPCOfferDetail.odSubconstItemGrid), , , vbTextCompare)
  ls_req = Replace(ls_req, "$SYS_UseCPro$", mo_Tools.SqlBool(SYS_UseCPro), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_P$", mo_Tools.SqlDbl(PUS_P * 1000), , , vbTextCompare)
  ls_req = Replace(ls_req, "$Language_Code$", mo_Tools.SQLStr(Language_Code), , , vbTextCompare)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  While Not mo_Db.EOF(lc_Cursor)
    Set lo_Subart = New DPC_SubArt
    Call InitSubconst(lo_Subart, eDPCOfferDetail.odSubconstItemGrid, eDPCRowStatus.rsAdd)
    Call ReadSubconst(lo_Subart, lc_Cursor)
    Call lo_Subart.CalculateRequiredQty(PUS_QtyM2, PUS_QtyPCS, PUS_A0, PUS_A1, PUS_A2)
    Call LoadSubArtPrice(lo_Subart)
    Call SubconstAdd(lo_Subart)
    Call mo_Db.Next(lc_Cursor)
  Wend
  Call mo_Db.Close(lc_Cursor)

  If PUS_PaSec Then
    ls_req = "exec DPC_SysSubSecPa_lst2 $SYS_Id$,$SHT_Id$,$DOF_Id$, $SYS_UseCPro$, $PUS_P$, $Language_Code$"
    
    ls_req = Replace(ls_req, "$SYS_Id$", mo_Tools.SqlInt(SYS_Id), , , vbTextCompare)
    ls_req = Replace(ls_req, "$SHT_Id$", mo_Tools.SqlInt(SHT_Id), , , vbTextCompare)
    ls_req = Replace(ls_req, "$DOF_Id$", mo_Tools.SqlInt(eDPCOfferDetail.odSubconstItemPanelSecurity), , , vbTextCompare)
    ls_req = Replace(ls_req, "$SYS_UseCPro$", mo_Tools.SqlBool(SYS_UseCPro), , , vbTextCompare)
    ls_req = Replace(ls_req, "$PUS_P$", mo_Tools.SqlDbl(PUS_P * 1000), , , vbTextCompare)
    ls_req = Replace(ls_req, "$Language_Code$", mo_Tools.SQLStr(Language_Code), , , vbTextCompare)
    lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
    While Not mo_Db.EOF(lc_Cursor)
      Set lo_Subart = New DPC_SubArt
      Call InitSubconst(lo_Subart, eDPCOfferDetail.odSubconstItemPanelSecurity, eDPCRowStatus.rsAdd)
      Call ReadSubconst(lo_Subart, lc_Cursor)
      Call lo_Subart.CalculateRequiredQty(PUS_QtyM2, PUS_QtyPCS, PUS_A0, PUS_A1, PUS_A2)
      Call LoadSubArtPrice(lo_Subart)
      Call SubconstAdd(lo_Subart)
      Call mo_Db.Next(lc_Cursor)
    Wend
    Call mo_Db.Close(lc_Cursor)
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("Calculate")
End Function

Public Function GenerateOfferDetail() As Collection
On Error GoTo ErrHandler

Dim lo_Collection As New Collection
Dim lo_Offer As DPC_OfferPos
Dim ll_Idx As Long
Dim lo_Subart As DPC_SubArt
Dim ll_OFD_Order As Long
Dim le_OFD_Type As eDPCPriceBookType

  ll_OFD_Order = 1
  le_OFD_Type = eDPCPriceBookType.eSubconstruction
  Set lo_Offer = GetOfferPos(eDPCOfferDetail.odSubconstPosition)
  lo_Offer.COF_Id = COF_Id
  lo_Offer.OFD_Main = eDPCOfferDetailMain.odMain
  lo_Offer.OFD_Type = le_OFD_Type
  lo_Offer.PRD_Name = ReplaceValuePlaceholder(lo_Offer.DOF_NTemp)
  lo_Offer.PRD_Desc = ReplaceValuePlaceholder(lo_Offer.DOF_DTemp)
  lo_Offer.PRD_Code = PRD_Code
  lo_Offer.PRD_Id = PUS_Id
  lo_Offer.OFD_Pos = OFD_Pos
  lo_Offer.OFD_PosCus = OFD_PosCus
  lo_Offer.OFD_WshDat = OFD_WshDat
  lo_Offer.OFD_ShpDat = OFD_ShpDat
  lo_Offer.OFD_DelDat = OFD_DelDat
  lo_Offer.OFD_IsFree = OFD_IsFree
  lo_Offer.OFD_IsAsItem = OFD_IsAsItem
  lo_Offer.VEN_Id = VEN_Id
  lo_Offer.SAE_Id = SAE_Id
  lo_Offer.SHP_Id = SHP_Id
  
  lo_Offer.VEN_Name = VEN_Name
  lo_Offer.SAE_Name = SAE_Name
  lo_Offer.SHP_Name = SHP_Name
  lo_Offer.OFD_Valid = True
  lo_Offer.OFD_Order = ll_OFD_Order
  lo_Offer.OFD_HasQty = True
  lo_Offer.OFD_HasPrice = False
  lo_Offer.OFD_HasTotal = False
  
  lo_Offer.CURR_Code = CURR_Code
  If lo_Offer.LEV_Id = eDPCLevel.lvNone Then
    lo_Offer.LEV_Id = eDPCLevel.lvStandard
  End If
  Call lo_Collection.Add(lo_Offer)
  ll_OFD_Order = ll_OFD_Order + 1
  For Each lo_Subart In Subconst
    Set lo_Offer = lo_Subart.OfferPos
    Select Case lo_Offer.DOF_Id
    Case eDPCOfferDetail.odSubconstItemSusp, _
         eDPCOfferDetail.odSubconstItemGrid, _
         eDPCOfferDetail.odSubconstItemPanelSecurity, _
         eDPCOfferDetail.odSubconstItemAdditional
      lo_Offer.OFD_Main = eDPCOfferDetailMain.odChild
      lo_Offer.COF_Id = COF_Id
      lo_Offer.OFD_Type = le_OFD_Type
      lo_Offer.PRD_Id = lo_Subart.SUA_Id
      lo_Offer.PRD_Code = lo_Subart.PRD_Code
      lo_Offer.OFD_Pos = OFD_Pos + ll_OFD_Order - 1
      lo_Offer.PRD_Name = lo_Subart.ReplaceValuePlaceholder(lo_Offer.DOF_NTemp)
      lo_Offer.PRD_Desc = lo_Subart.ReplaceValuePlaceholder(lo_Offer.DOF_DTemp)
      lo_Offer.OFD_Valid = True
      lo_Offer.OFD_Order = ll_OFD_Order
      lo_Offer.CURR_Code = CURR_Code
      lo_Offer.OFD_HasQty = True
      lo_Offer.OFD_HasPrice = True
      lo_Offer.OFD_HasTotal = True
      If lo_Offer.LEV_Id = eDPCLevel.lvNone Then
        lo_Offer.LEV_Id = eDPCLevel.lvStandard
      End If
      Call lo_Collection.Add(lo_Offer)
      ll_OFD_Order = ll_OFD_Order + 1
    Case Else
    End Select
  Next
  Set GenerateOfferDetail = lo_Collection
  Exit Function
ErrHandler:
  Call ErrorHandler("GenerateOfferDetail")
End Function

Public Sub Load(ByVal as_PUS_Id As String)
On Error GoTo ErrHandler

  Call LoadPrdSub(as_PUS_Id)
  Call LoadPrdSubArt(as_PUS_Id)
  Call CalculateHangerLimits
  Exit Sub
ErrHandler:
  Call ErrorHandler("Load")
End Sub

Public Sub LoadPrdSub(ByVal as_PUS_Id As String)
On Error GoTo ErrHandler

Dim lc_Cursor As Long
Dim ls_req As String
Dim ld_QtyM2 As Double

  ls_req = "exec DPC_PrdSub_Sel $PUS_ID$,$Language_Code$"
  ls_req = Replace(ls_req, "$PUS_ID$", mo_Tools.SQLStr(as_PUS_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req, 1)
  PUS_Id = mo_Db.GetFields(lc_Cursor, "PUS_Id")
  CAT_Id = mo_Db.GetFields(lc_Cursor, "CAT_Id")
  PRD_IdPar = mo_Db.GetFields(lc_Cursor, "PRD_IdPar")
  PRD_Child = mo_Db.GetFields(lc_Cursor, "PRD_Child")
  PRD_Code = mo_Db.GetFields(lc_Cursor, "PRD_Code")
  PRD_CodeC = mo_Db.GetFields(lc_Cursor, "PRD_CodeC")
  Vendor_Id = mo_Db.GetFields(lc_Cursor, "Vendor_Id")
  LEV_Id = mo_Db.GetFields(lc_Cursor, "LEV_Id")
  IMG_Id = mo_Db.GetFields(lc_Cursor, "IMG_Id")
  IMG_IdSHT = mo_Db.GetFields(lc_Cursor, "IMG_IdSHT")
  
  SHT_Id = mo_Db.GetFields(lc_Cursor, "SHT_Id")
  SHT_Name = mo_Db.GetFields(lc_Cursor, "SHT_Name")
  SHT_Group = mo_Db.GetFields(lc_Cursor, "SHT_Group")
  SHT_MinA2 = Round(mo_Db.GetFields(lc_Cursor, "SHT_MinA2"), 3)
  SHT_MaxA2 = Round(mo_Db.GetFields(lc_Cursor, "SHT_MaxA2"), 3)
  SHT_MinA1 = Round(mo_Db.GetFields(lc_Cursor, "SHT_MinA1"), 3)
  SHT_MaxA1 = Round(mo_Db.GetFields(lc_Cursor, "SHT_MaxA1"), 3)
  SHT_MinA0 = Round(mo_Db.GetFields(lc_Cursor, "SHT_MinA0"), 3)
  SHT_MaxA0 = Round(mo_Db.GetFields(lc_Cursor, "SHT_MaxA0"), 3)
  SHT_MinH = Round(mo_Db.GetFields(lc_Cursor, "SHT_MinH"), 3)
  SHT_MaxH = Round(mo_Db.GetFields(lc_Cursor, "SHT_MaxH"), 3)
  SHT_MinPA = Round(mo_Db.GetFields(lc_Cursor, "SHT_MinPA"), 3)
  SHT_MaxPA = Round(mo_Db.GetFields(lc_Cursor, "SHT_MaxPA"), 3)
  SHT_MinPB = Round(mo_Db.GetFields(lc_Cursor, "SHT_MinPB"), 3)
  SHT_MaxPB = Round(mo_Db.GetFields(lc_Cursor, "SHT_MaxPB"), 3)
  SHT_Cover = mo_Db.GetFields(lc_Cursor, "SHT_Cover")
  
  STA_Id = mo_Db.GetFields(lc_Cursor, "STA_Id")
  SYS_Id = mo_Db.GetFields(lc_Cursor, "SYS_Id")
  SYS_Name = mo_Db.GetFields(lc_Cursor, "SYS_Name")
  SYS_Desc = mo_Db.GetFields(lc_Cursor, "SYS_Desc")
  SYS_PaSec = StrComp(mo_Db.GetFields(lc_Cursor, "SYS_PaSec"), "X", vbTextCompare) = 0
  SYS_UseCPro = StrComp(mo_Db.GetFields(lc_Cursor, "SYS_UseCPro"), "X", vbTextCompare) = 0
  PUS_HaAlg = mo_Db.GetFields(lc_Cursor, "PUS_HaAlg")
  PUS_HaAlgDesc = mo_Db.GetFields(lc_Cursor, "PUS_HaAlgDesc")
  PUS_Load = mo_Db.GetFields(lc_Cursor, "PUS_Load")
  PUS_LoadDesc = mo_Db.GetFields(lc_Cursor, "PUS_LoadDesc")
  PUS_Height = mo_Db.GetFields(lc_Cursor, "PUS_Height")
  PUS_A0 = Round(mo_Db.GetFields(lc_Cursor, "PUS_A0"), 3)
  PUS_A1 = Round(mo_Db.GetFields(lc_Cursor, "PUS_A1"), 3)
  PUS_A2 = Round(mo_Db.GetFields(lc_Cursor, "PUS_A2"), 3)
  PUS_PaSec = StrComp(mo_Db.GetFields(lc_Cursor, "PUS_PaSec"), "X", vbTextCompare) = 0
  PUS_PanA = Round(mo_Db.GetFields(lc_Cursor, "PUS_PanA"), 3)
  PUS_PanB = Round(mo_Db.GetFields(lc_Cursor, "PUS_PanB"), 3)
  PUS_P = Round(mo_Db.GetFields(lc_Cursor, "PUS_P"), 3)
  SLC_Idx = mo_Db.GetFields(lc_Cursor, "SLC_Idx")
  RF_DescA0 = mo_Db.GetFields(lc_Cursor, "RF_DescA0")
  RF_DescA1 = mo_Db.GetFields(lc_Cursor, "RF_DescA1")
  RF_DescA2 = mo_Db.GetFields(lc_Cursor, "RF_DescA2")
  ld_QtyM2 = Round(mo_Db.GetFields(lc_Cursor, "PUS_QtyM2"), 2)
  Call OfferPos.Init(ld_QtyM2, ld_QtyM2, eDPCQtyType.qtM2, 0, ModuleSurface, PanelSurface)
  Call mo_Db.Close(lc_Cursor)
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadPrdSub")
End Sub

Public Sub LoadPrdSubArt(ByVal as_PUS_Id As String)
On Error GoTo ErrHandler

Dim lc_Cursor As Long
Dim ls_req As String
Dim lo_DOF_Id As eDPCOfferDetail
Dim lo_Subart As DPC_SubArt

  Call mo_Tools.ClearCollection(Subconst)
  ls_req = "exec DPC_PrdSubArt_lst $COF_Id$, $OFD_Id$, $PUS_ID$, $Language_Code$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(""), , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Id$", mo_Tools.SQLStr(""), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PUS_ID$", mo_Tools.SQLStr(as_PUS_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  While Not mo_Db.EOF(lc_Cursor)
    lo_DOF_Id = mo_Db.GetFields(lc_Cursor, "DOF_Id")
    Set lo_Subart = New DPC_SubArt
    Call InitSubconst(lo_Subart, lo_DOF_Id, eDPCRowStatus.rsNone)
    Call ReadSubconst(lo_Subart, lc_Cursor)
    Call Subconst.Add(lo_Subart)
    Call mo_Db.Next(lc_Cursor)
  Wend
  Call mo_Db.Close(lc_Cursor)
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadPrdSubArt")
End Sub

Private Sub ResetSubconstQtyPrice(ByVal ad_Qty As Double, ByVal ae_Qtytype As eDPCQtyType)
On Error GoTo ErrHandler

Dim lo_Offer As DPC_OfferPos
Dim lo_Subart As DPC_SubArt

  Call OfferPos.Init(ad_Qty, ad_Qty, ae_Qtytype, 0, ModuleSurface, PanelSurface)
  For Each lo_Subart In Subconst
    Call lo_Subart.OfferPos.Init(ad_Qty, ad_Qty, eDPCQtyType.qtPU, 0, ModuleSurface, PanelSurface)
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("ResetSubconstQtyPrice")
End Sub

Public Sub LoadOffer(ByVal as_COF_Id As String, ByVal as_OFD_IdPar As String)
On Error GoTo ErrHandler

Dim le_DOF_Id As eDPCOfferDetail
Dim ls_PRD_Id As String
Dim lo_Offer As DPC_OfferPos
Dim ls_req As String
Dim lc_Cursor As Long

  Call ResetSubconstQtyPrice(0, eDPCQtyType.qtUnknown)
  ls_req = "exec Cap_OfferDetail_lst2 $COF_Id$, $Language_Code$, $OFD_Main$, $OFD_IdPar$, $OFD_Valid$, $OFD_Id$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$Language_Code$", mo_Tools.SQLStr(ms_Language_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Main$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_IdPar$", mo_Tools.SQLStr(as_OFD_IdPar), , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Valid$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Id$", "NULL", , , vbTextCompare)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)

  Call mo_Db.First(lc_Cursor)
  While Not mo_Db.EOF(lc_Cursor)

    le_DOF_Id = mo_Db.GetFields(lc_Cursor, "DOF_Id")
    ls_PRD_Id = mo_Db.GetFields(lc_Cursor, "PRD_ID")

    Set lo_Offer = GetOfferPos(le_DOF_Id, ls_PRD_Id)
    If Not lo_Offer Is Nothing Then
      Call lo_Offer.ReadOfferPos(mo_Db, lc_Cursor)
    End If
    Call mo_Db.Next(lc_Cursor)
  Wend
  Call mo_Db.Close(lc_Cursor)

  Set lo_Offer = GetOfferPos(eDPCOfferDetail.odSubconstPosition)
  OFD_Pos = lo_Offer.OFD_Pos
  OFD_PosCus = lo_Offer.OFD_PosCus
  PRD_CodeC = lo_Offer.PRD_CodeC
  OFD_WshDat = lo_Offer.OFD_WshDat
  OFD_ShpDat = lo_Offer.OFD_ShpDat
  OFD_DelDat = lo_Offer.OFD_DelDat
  LEN_Id = lo_Offer.LEN_Id
  SAE_Id = lo_Offer.SAE_Id
  SHP_Id = lo_Offer.SHP_Id
  VEN_Id = lo_Offer.VEN_Id
  SAE_Name = lo_Offer.SAE_Name
  SHP_Name = lo_Offer.SHP_Name
  VEN_Name = lo_Offer.VEN_Name
  COF_Id = lo_Offer.COF_Id
  OFD_IsAsItem = lo_Offer.OFD_IsAsItem
  OFD_IsFree = lo_Offer.OFD_IsFree
  OFD_MarginS = lo_Offer.OFD_MarginS
  OFD_GTN = lo_Offer.OFD_GTN
  OFD_MarginMin = lo_Offer.OFD_MarginMin
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadOffer")
End Sub

Public Function OfferOrder(ByVal ao_Collection As Collection) As Collection
On Error GoTo ErrHandler

Dim ll_Idx1 As Long, ll_Idx2 As Long
Dim lo_OfferPos1 As DPC_OfferPos, lo_OfferPos2 As DPC_OfferPos

  For ll_Idx1 = 1 To ao_Collection.Count
    For ll_Idx2 = 1 To ao_Collection.Count - ll_Idx1
      Set lo_OfferPos1 = ao_Collection(ll_Idx2)
      Set lo_OfferPos2 = ao_Collection(ll_Idx2 + 1)
      If lo_OfferPos1.OFD_Order > lo_OfferPos2.OFD_Order Then
        Call ao_Collection.Remove(ll_Idx2)
        Call ao_Collection.Add(lo_OfferPos1, , , ll_Idx2)
      End If
    Next
  Next
  Set lo_OfferPos1 = Nothing
  Set lo_OfferPos2 = Nothing
  Set OfferOrder = ao_Collection
  Exit Function
ErrHandler:
  Call ErrorHandler("OfferOrder")
End Function

Public Function GetOfferPos(ByVal al_DOF_Id As Long, Optional ByVal as_PRD_Id As String = "") As DPC_OfferPos
On Error GoTo ErrHandler

Dim lo_Offer As DPC_OfferPos
Dim lo_Subart As DPC_SubArt
Dim le_Category As eDPCCategory

  If al_DOF_Id = eDPCOfferDetail.odSubconstPosition Then
    Set GetOfferPos = OfferPos
  Else
    For Each lo_Subart In Subconst
      If (lo_Subart.OfferPos.DOF_Id = al_DOF_Id) And (lo_Subart.SUA_Id = as_PRD_Id) Then
        Set GetOfferPos = lo_Subart.OfferPos
        Exit Function
      End If
    Next
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("GetOfferPos")
End Function

Public Function ReplaceValuePlaceholder(ByVal as_Text As String) As String
On Error GoTo ErrHandler

Dim ll_SideIdx As Long
Dim ll_SchIdx As Long

  as_Text = Replace(as_Text, "$PRD_Id$", PUS_Id, , , vbTextCompare)
  as_Text = Replace(as_Text, "$PRD_Code$", PRD_Code, , , vbTextCompare)
  as_Text = Replace(as_Text, "$PRD_CodeC$", PRD_CodeC, , , vbTextCompare)
  'as_Text = Replace(as_Text, "$PRD_Name$", SBT_Name, , , vbTextCompare)
  'as_Text = Replace(as_Text, "$PRD_Desc$", SBT_Desc, , , vbTextCompare)
  as_Text = Replace(as_Text, "$LEV_Id$", LEV_Id, , , vbTextCompare)
  
  as_Text = Replace(as_Text, "$SYS_Id$", SYS_Id, , , vbTextCompare)
  as_Text = Replace(as_Text, "$SYS_Name$", SYS_Name, , , vbTextCompare)
  as_Text = Replace(as_Text, "$SYS_Desc$", SYS_Desc, , , vbTextCompare)
  ReplaceValuePlaceholder = as_Text
  Exit Function
ErrHandler:
  Call ErrorHandler("ReplaceValuePlaceholder")
End Function

Public Sub LoadSystemMargin()
On Error GoTo ErrHandler

Dim ls_req As String
Dim lo_Offer As DPC_OfferPos
Dim lo_Subart As DPC_SubArt
Dim lc_Cursor As Long
  
  OFD_MarginS = 0
  OFD_GTN = 0
  OFD_MarginMin = 0
  
  ls_req = "exec DPC_SysMargin_sel $CT_Code$, $Language_Code$"
  ls_req = Replace(ls_req, "$CT_Code$", mo_Tools.SQLStr(CT_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$SYS_Id$", mo_Tools.SqlInt(SYS_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  If mo_Db.RowCount(lc_Cursor) = 1 Then
    OFD_MarginS = mo_Db.GetFields(lc_Cursor, "SMA_SubMargin")
    OFD_GTN = mo_Db.GetFields(lc_Cursor, "SMA_SubGTN")
    OFD_MarginMin = mo_Db.GetFields(lc_Cursor, "SMA_SubMin")
  Else
    Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 666, "#System margin and GTN is not found in database for country '$CT_Code$' and system '$SYS_Name$'", Array("$CT_Code$", CT_Code, "$SYS_Name$", SYS_Name))
  End If
  Call mo_Db.Close(lc_Cursor)
  
'  If Not OfferPos Is Nothing Then
'    OfferPos.OFD_MarginMin = OFD_MarginMin
'    OfferPos.OFD_MarginS = OFD_MarginS
'    OfferPos.OFD_GTN = OFD_GTN
'  End If
'
'  For Each lo_Subart In Subconst
'    lo_Subart.OfferPos.OFD_MarginMin = OFD_MarginMin
'    lo_Subart.OfferPos.OFD_MarginS = OFD_MarginS
'    lo_Subart.OfferPos.OFD_GTN = OFD_GTN
'    Call lo_Subart.OfferPos.CalculateGrossSellingPrice
'  Next
'
'  Call CalcPositionPrice
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadSystemMargin")
End Sub

Public Sub ReadSubconst(ByVal ao_SubArt As DPC_SubArt, ByVal al_Cursor As Long)
On Error GoTo ErrHandler

  ao_SubArt.SUA_Id = mo_Db.GetFields(al_Cursor, "SUA_Id")
  ao_SubArt.PRD_Code = mo_Db.GetFields(al_Cursor, "PRD_Code")
  ao_SubArt.PRD_Name = mo_Db.GetFields(al_Cursor, "PRD_Name")
  ao_SubArt.PRD_Desc = mo_Db.GetFields(al_Cursor, "PRD_Desc")
  ao_SubArt.IMG_Id = mo_Db.GetFields(al_Cursor, "IMG_Id")
  ao_SubArt.Vendor_Id = mo_Db.GetFields(al_Cursor, "Vendor_Id")
  
  ao_SubArt.SUA_Type = mo_Db.GetFields(al_Cursor, "SUA_Type")
  ao_SubArt.SUA_Stat = mo_Db.GetFields(al_Cursor, "SUA_Stat")
  ao_SubArt.SUA_MatDesc = mo_Db.GetFields(al_Cursor, "SUA_MatDesc")
  ao_SubArt.SUA_Mat = mo_Db.GetFields(al_Cursor, "SUA_Mat")
  ao_SubArt.SUA_Thick = mo_Db.GetFields(al_Cursor, "SUA_Thick")
  ao_SubArt.SUA_Bwrt = mo_Db.GetFields(al_Cursor, "SUA_Bwrt")
  ao_SubArt.SUA_PU = mo_Db.GetFields(al_Cursor, "SUA_PU")
  ao_SubArt.SUA_Wght = mo_Db.GetFields(al_Cursor, "SUA_Wght")
  ao_SubArt.SUA_PUWgh = mo_Db.GetFields(al_Cursor, "SUA_WgPU")
  ao_SubArt.UM_Code = mo_Db.GetFields(al_Cursor, "UM_Code")
  ao_SubArt.UM_Name = mo_Db.GetFields(al_Cursor, "UM_Name")
  ao_SubArt.PSA_NeedPCS = mo_Db.GetFields(al_Cursor, "PSA_NeedPCS")
  ao_SubArt.PSA_NeedM2 = mo_Db.GetFields(al_Cursor, "PSA_NeedM2")
  ao_SubArt.SUA_Grid = StrComp(mo_Db.GetFields(al_Cursor, "SUA_Grid"), "X", vbTextCompare) = 0
  
  ao_SubArt.SSA_Formula = mo_Db.GetFields(al_Cursor, "SSA_Formula")
  ao_SubArt.SSA_Value = mo_Db.GetFields(al_Cursor, "SSA_Value")
  ao_SubArt.SHL_Cover = mo_Db.GetFields(al_Cursor, "SHL_Cover")
  
  Call ao_SubArt.OfferPos.Init(0, 0, eDPCQtyType.qtPU, ao_SubArt.SUA_PU, ModuleSurface, PanelSurface)
  If mo_Db.GetFieldIndex(al_Cursor, "DOF_Id") >= 0 Then
    ao_SubArt.OfferPos.DOF_Id = mo_Db.GetFields(al_Cursor, "DOF_Id")
    ao_SubArt.OfferPos.DOF_Name = mo_Db.GetFields(al_Cursor, "DOF_Name")
  End If
  
  Exit Sub
ErrHandler:
  Call ErrorHandler("ReadSubconst")
End Sub

Public Function GetSubconst(ByVal al_SubconstIdx As Long) As DPC_SubArt
On Error GoTo ErrHandler

Dim ll_Idx As Long
Dim lo_Subart As DPC_SubArt

  Set GetSubconst = Nothing
  For Each lo_Subart In Subconst
    If lo_Subart.Idx = al_SubconstIdx Then
      Set GetSubconst = lo_Subart
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("GetSubconst")
End Function

Public Function GetSubconstBySUA_Id(ByVal as_SUA_Id As String) As DPC_SubArt
On Error GoTo ErrHandler

Dim ll_Idx As Long
Dim lo_Subart As DPC_SubArt

  Set GetSubconstBySUA_Id = Nothing
  For Each lo_Subart In Subconst
    If (lo_Subart.SUA_Id = as_SUA_Id) And (lo_Subart.RowStatus <> eDPCRowStatus.rsDrop) Then
      Set GetSubconstBySUA_Id = lo_Subart
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("GetSubconstBySUA_Id")
End Function

Public Sub SubconstAdd(ByVal ao_SubArt As DPC_SubArt)
On Error GoTo ErrHandler

  ao_SubArt.RowStatus = eDPCRowStatus.rsAdd
  Call Subconst.Add(ao_SubArt)
  Exit Sub
ErrHandler:
  Call ErrorHandler("SubconstAdd")
End Sub

Public Sub SubconstUpdate(ByVal ao_SubArt As DPC_SubArt)
On Error GoTo ErrHandler
  
  If ao_SubArt.RowStatus = eDPCRowStatus.rsNone Then
    ao_SubArt.RowStatus = eDPCRowStatus.rsUpdate
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("SubconstUpdate")
End Sub

Public Sub SubconstDrop(ByVal ao_SubArt As DPC_SubArt)
On Error GoTo ErrHandler

Dim ll_Idx As Long
Dim lo_Subart As DPC_SubArt

  For ll_Idx = 1 To Subconst.Count
    Set lo_Subart = Subconst(ll_Idx)
    If lo_Subart.Idx = ao_SubArt.Idx Then
      Call Subconst.Remove(ll_Idx)
'      If lo_SubArt.RowStatus = eDPCRowStatus.rsAdd Then
'        Call Subconst.Remove(ll_Idx)
'      Else
'        lo_SubArt.RowStatus = eDPCRowStatus.rsDrop
'      End If
      Exit Sub
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("SubconstDrop")
End Sub

Public Sub CalcPositionPrice()
On Error GoTo ErrHandler

Dim ld_Price As Double, ld_PriceA As Double
Dim ld_Cost As Double, ld_CostA As Double
Dim lo_Subart As DPC_SubArt
Dim lo_Offer As DPC_OfferPos

  ld_Price = 0
  ld_PriceA = 0
  ld_Cost = 0
  ld_CostA = 0
  For Each lo_Subart In Subconst
    ld_Cost = ld_Cost + lo_Subart.OfferPos.OFD_TotalC
    ld_CostA = ld_CostA + (lo_Subart.OfferPos.OFD_CostA * lo_Subart.OfferPos.OFD_Qty)        ' + lo_Subart.OfferPos.OFD_TotalCA
    ld_Price = ld_Price + lo_Subart.OfferPos.OFD_TotalP
    ld_PriceA = ld_PriceA + (lo_Subart.OfferPos.OFD_PriceA * lo_Subart.OfferPos.OFD_Qty)     ' + lo_Subart.OfferPos.OFD_TotalPA
  Next
  Set lo_Offer = GetOfferPos(eDPCOfferDetail.odSubconstPosition)
  
  If lo_Offer.OFD_Qty > 0 Then
    ld_Cost = ld_Cost / lo_Offer.OFD_Qty
    ld_Price = ld_Price / lo_Offer.OFD_Qty
  Else
    ld_Cost = 0
    ld_Price = 0
  End If
  If lo_Offer.OFD_QtyA > 0 Then
    ld_CostA = ld_CostA / lo_Offer.OFD_QtyA
    ld_PriceA = ld_PriceA / lo_Offer.OFD_QtyA
  Else
    ld_CostA = 0
    ld_PriceA = 0
  End If
  
  Call lo_Offer.SetCost(DPC_UOM_M2, ld_Cost)
  Call lo_Offer.SetCostA(DPC_UOM_M2, ld_CostA)
  If OFD_IsFree Then
    Call lo_Offer.SetPrice(DPC_UOM_M2, 0)
  Else
    Call lo_Offer.SetPrice(DPC_UOM_M2, ld_Price)
  End If
  Call lo_Offer.SetPriceA(DPC_UOM_M2, ld_PriceA)
  Exit Sub
ErrHandler:
  Call ErrorHandler("CalcPositionPrice")
End Sub

Public Sub LoadError()
On Error GoTo ErrHandler

Dim ls_req As String

  If mc_Error = 0 Then
    ls_req = "exec DPC_Error_lst $Language_Code$"
    ls_req = ReplaceCommonPlaceholders(ls_req)
    mc_Error = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadError")
End Sub

Public Function IsErrorType(ByVal ao_ErrCol As Collection, ByVal al_ErrType As Long) As Boolean
On Error GoTo ErrHandler

Dim lo_Error As DPC_Error

  IsErrorType = False
  For Each lo_Error In ao_ErrCol
    If lo_Error.ERR_Type = al_ErrType Then
      IsErrorType = True
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("IsErrorType")
End Function

Public Function HasErrorID(ByVal ao_ErrCol As Collection, ByVal al_Err_Id As Long) As Boolean
On Error GoTo ErrHandler

Dim lo_Error As DPC_Error

  HasErrorID = False
  For Each lo_Error In ao_ErrCol
    If lo_Error.ERR_ID = al_Err_Id Then
      HasErrorID = True
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("HasErrorID")
End Function

Public Function GetErrorMessage(ByVal ao_ErrCol As Collection) As String
On Error GoTo ErrHandler

Dim lo_Error As DPC_Error
Dim ls_ErrorMessage As String

  ls_ErrorMessage = ""
  For Each lo_Error In ao_ErrCol
    If lo_Error.Message_Text <> "" Then
      If ls_ErrorMessage <> "" Then ls_ErrorMessage = ls_ErrorMessage & vbCrLf
      ls_ErrorMessage = ls_ErrorMessage & lo_Error.Message_Text
    End If
  Next
  GetErrorMessage = ls_ErrorMessage
  Exit Function
ErrHandler:
  Call ErrorHandler("GetErrorMessage")
End Function

Public Function GetErrorType(ByVal ao_ErrCol As Collection) As Long
On Error GoTo ErrHandler

Dim lo_Error As DPC_Error

  GetErrorType = eDPCErrorType.etNone
  If IsErrorType(ao_ErrCol, eDPCErrorType.etStop) Then
    GetErrorType = eDPCErrorType.etStop
  ElseIf IsErrorType(ao_ErrCol, eDPCErrorType.etNeedApproval) Then
    GetErrorType = eDPCErrorType.etNeedApproval
  ElseIf IsErrorType(ao_ErrCol, eDPCErrorType.etInfo) Then
    GetErrorType = eDPCErrorType.etInfo
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("GetErrorType")
End Function

Public Function ErrorOrder(ByVal lo_ErrCol As Collection) As Collection
On Error GoTo ErrHandler

Dim lo_Error As DPC_Error
Dim ll_ErrType As eDPCErrorType
Dim lo_ErrColOrdered As New Collection

  ll_ErrType = eDPCErrorType.etStop
  For Each lo_Error In lo_ErrCol
    If lo_Error.ERR_Type = ll_ErrType Then
      Call lo_ErrColOrdered.Add(lo_Error)
    End If
  Next
  ll_ErrType = eDPCErrorType.etNeedApproval
  For Each lo_Error In lo_ErrCol
    If lo_Error.ERR_Type = ll_ErrType Then
      Call lo_ErrColOrdered.Add(lo_Error)
    End If
  Next
  ll_ErrType = eDPCErrorType.etInfo
  For Each lo_Error In lo_ErrCol
    If lo_Error.ERR_Type = ll_ErrType Then
      Call lo_ErrColOrdered.Add(lo_Error)
    End If
  Next
  Set ErrorOrder = lo_ErrColOrdered
  Exit Function
ErrHandler:
  Call ErrorHandler("ErrorOrder")
End Function

Private Function GetError(ByVal al_Err_Id As Long) As DPC_Error
On Error GoTo ErrHandler

Dim lo_DPC_Error As DPC_Error

  Set GetError = Nothing
  For Each lo_DPC_Error In Errors
    If lo_DPC_Error.ERR_ID = al_Err_Id Then
      Set GetError = lo_DPC_Error
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("GetError")
End Function

Public Function GetErrorText(ByVal al_Err_Id As Long) As String
On Error GoTo ErrHandler

Dim lo_DPC_Error As DPC_Error

  GetErrorText = ""
  Set lo_DPC_Error = GetError(al_Err_Id)
  If Not lo_DPC_Error Is Nothing Then
    GetErrorText = lo_DPC_Error.TXT_Text
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("GetErrorText")
End Function

Public Sub SetErrorText(ByVal al_Err_Id As Long, ByVal as_Text As String)
On Error GoTo ErrHandler

Dim lo_DPC_Error As DPC_Error

  Set lo_DPC_Error = GetError(al_Err_Id)
  If lo_DPC_Error Is Nothing Then
    Call AddCheckError(al_Err_Id, Errors, , , as_Text)
  Else
    lo_DPC_Error.TXT_Text = as_Text
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("SetErrorText")
End Sub

Public Sub CopyErrorText(ByVal ao_ErrCollection As Collection)
On Error GoTo ErrHandler

Dim lo_Error As DPC_Error
Dim lo_SavedError As DPC_Error

  For Each lo_Error In ao_ErrCollection
    Set lo_SavedError = GetError(lo_Error.ERR_ID)
    If Not (lo_SavedError Is Nothing) Then
      lo_Error.TXT_Text = lo_SavedError.TXT_Text
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("CopyErrorText")
End Sub

Public Sub UpdateErrorText(ByVal ao_ErrCollection As Collection)
On Error GoTo ErrHandler

Dim lo_Error As DPC_Error
Dim lo_SavedError As DPC_Error

  For Each lo_Error In ao_ErrCollection
    Set lo_SavedError = GetError(lo_Error.ERR_ID)
    If lo_SavedError Is Nothing Then
      If Trim(lo_Error.TXT_Text) <> "" Then
        Call Errors.Add(lo_Error)
      End If
    Else
      lo_SavedError.TXT_Text = lo_Error.TXT_Text
    End If
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("UpdateErrorText")
End Sub

Private Sub AddCheckError(ByVal ae_DPCError As eDPCError, ByVal ao_ErrCol As Collection, Optional av_PlaceHolder As Variant, Optional av_Value As Variant, Optional as_Text As String)
On Error GoTo ErrHandler

Dim lo_Error As DPC_Error
Dim lo_SavedError As DPC_Error
Dim ll_Idx As Long

  If mo_Db.Find(mc_Error, "ERR_Id", ae_DPCError) >= 0 Then
    Set lo_Error = New DPC_Error
    Set lo_Error.Tools = mo_Tools
    lo_Error.ERR_ID = ae_DPCError
    lo_Error.LEV_Id = mo_Db.GetFields(mc_Error, "LEV_Id")
    lo_Error.ERR_Type = mo_Db.GetFields(mc_Error, "ERR_Type")
    lo_Error.MsgId = mo_Db.GetFields(mc_Error, "MsgId")
    lo_Error.ERR_Ctrl = mo_Db.GetFields(mc_Error, "ERR_Ctrl")
    lo_Error.ERR_Offer = StrComp(mo_Db.GetFields(mc_Error, "ERR_Offer"), "X", vbTextCompare) = 0
    lo_Error.Message_Text = ReplaceValuePlaceholder(mo_Db.GetFields(mc_Error, "Message_Text"))
    If as_Text = "" Then
      Set lo_SavedError = GetError(ae_DPCError)
      If Not lo_SavedError Is Nothing Then
        lo_Error.TXT_Text = lo_SavedError.TXT_Text
      End If
    Else
      lo_Error.TXT_Text = as_Text
    End If
    If IsArray(av_PlaceHolder) Then
      For ll_Idx = 0 To UBound(av_PlaceHolder)
        lo_Error.Message_Text = Replace(lo_Error.Message_Text, CStr(av_PlaceHolder(ll_Idx)), CStr(av_Value(ll_Idx)))
      Next
    Else
      lo_Error.Message_Text = Replace(lo_Error.Message_Text, CStr(av_PlaceHolder), CStr(av_Value))
    End If
    Call ao_ErrCol.Add(lo_Error)
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("AddCheckError")
End Sub

Private Function ReplaceCommonPlaceholders(ByVal as_Request As String) As String
On Error GoTo ErrHandler

    as_Request = Replace(as_Request, "$Z_Creator$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
    as_Request = Replace(as_Request, "$U_Code$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
    as_Request = Replace(as_Request, "$Z_Last_Upd_User$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
    as_Request = Replace(as_Request, "$Language_Code$", mo_Tools.SQLStr(Language_Code), , , vbTextCompare)
    as_Request = Replace(as_Request, "$iConcurrency$", mo_Tools.SqlInt(ml_iConcurrency), , , vbTextCompare)
    ReplaceCommonPlaceholders = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplaceCommonPlaceholders")
End Function

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub


